varying vec2 p_textureCoord;

varying vec4 p_color;
uniform sampler2D base_texture;
uniform float brightness;
uniform float contrast;

void main()
{
    vec4 resultColor = texture2D(base_texture, p_textureCoord) * p_color;
	vec3 calcResult = ((resultColor.xyz - 0.5) * max(contrast, 0.0)) + 0.5;
	calcResult += brightness;
	
	resultColor.xyz = resultColor.w * calcResult + (1.0 - resultColor.w) * resultColor.xyz;
	
    gl_FragColor = resultColor;
}
